<x-filament::page>
    <form wire:submit.prevent="submit" class="space-y-6">
        {{ $this->form }}

        <div class="flex flex-wrap items-center gap-4 justify-start">

            @if(!$isConfirmed)
            <x-filament::button type="submit">
                {{ __('profile.save') }}
            </x-filament::button>
            @endif

            <x-filament::button wire:click="showId" wire:loading.attr="disabled">
                {{ __('profile.show_id') }}
            </x-filament::button>


                @if(!$isConfirmed)
                    <x-filament::modal icon="heroicon-o-information-circle">
                    <x-slot name="trigger">
                        <x-filament::button>
                            {{ __('profile.confirm') }}
                        </x-filament::button>
                    </x-slot>

                    <x-slot name="heading">
                        {{ __('profile.confirm_id_card_msg') }}
                    </x-slot>

                    <x-slot name="description">
                        التعهد <br>
                        أتعهد بأن الصوره المرفقة وفق الشروط المحدده وأتحمل صحتها.
                        <br>
                        شروط الصوره:
                        <br>
                        - تكون ملونة ذات خلفية بيضاء.
                        <br>
                        - أن تكون الصورة حديثة تم التقاطها قبل 4 أشهر كحد أقصى.
                        <br>
                        - تكون ملامح الوجه واضحة وبدون تعابير.
                        <br>
                        - تكون الصوره بوجه متجهه للكاميرا بشكل مستقيم.
                    </x-slot>

                    <x-slot name="footerActions">
                        <x-filament::button wire:click="confirm" wire:loading.attr="disabled">
                            {{ __('profile.confirm') }}
                        </x-filament::button>

                        <x-filament::button wire:click="showId" wire:loading.attr="disabled">
                            {{ __('profile.show_id') }}
                        </x-filament::button>
                    </x-slot>

                {{-- Modal content --}}
                    </x-filament::modal>
                @endif
        </div>
    </form>
</x-filament::page>
