<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>
        {{ $course->title }}
    </title>
    <link rel="stylesheet" href="{{ asset('certs/css/style.css') }}" />
</head>
<body>
<div id="pdf"></div>
<script src="{{ asset('certs/js/pdf-lib.min.js') }}"></script>
<script src="{{ asset('certs/js/fontkit.umd.min.js') }}"></script>
<script src="{{ asset('certs/js/filesaver.js') }}"></script>
<script src="{{ asset('certs/js/index.js') }}"></script>
<script>
    const temp = "{{ $temp }}";
    const font = "{{ asset('certs/fonts/IBMPlexSansArabic-Bold.ttf') }}";
    const userName = "{{ $user->name }}";
    const course = "{{ $course->title }}";
    const startDate = "{{ englishNumberToArabic($course->start_at->format('Y/m/d') , reverse: true) }}";
    const endDate = "{{ englishNumberToArabic($course->end_at->format('Y/m/d') , reverse: true) }}";
    const days = "{{ englishNumberToArabic($course->getDays()->count() , reverse: true) }}";
    const hours = "{{ englishNumberToArabic($course->hours , reverse: true) }}";
    const download = {{ isset($download) && $download ? 'true' : 'false' }};
    const fileName = "{{ $course->title }} - {{ $user->name }}.pdf";
    generatePDF(
        download,
        fileName,
        userName,
        course,
        startDate,
        endDate,
        days,
        hours
    );
</script>
</body>
</html>
