<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        {{ $card->name }}
    </title>
    <link rel="stylesheet" href="{{ asset('card/css/style.css') }}" >
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
</head>

<body>
<main>
    <section class="card">
        <section class="card-top">
            <section class="card-top-logo">
                <img src="{{ asset('card/imgs/4.png') }}" alt="" srcset="">
            </section>
            <section class="card-top-avatar">
                <img src="{{ asset("storage/" . $card->photo) }}" alt="" srcset="">
            </section>
        </section>
        <section class="card-body">
            <section class="card-qrcode">
                {!! QrCode::size(100)->generate(route('guest.id' , ['user' => auth()->id()])); !!}
            </section>
            <section class="card-data">
                <ul>
                    <li>
                        <h3>الاسم</h3>
                        <span>
                            {{ $card->name }}
                        </span>
                    </li>
                    <li>
                        <h3>جهة العمل</h3>
                        <span>

                            {{ $employer }}
                        </span>
                    </li>

                    <li>
                        <h3>العمل</h3>
                        <span>
                            {{ $work }}
                        </span>
                    </li>

                    <li>
                        <h3>
                            تاريخ الاصدار
                        </h3>
                        <span>
                            {{ $card->created_at->format('Y-m-d') }}
                        </span>
                    </li>
                </ul>
            </section>
        </section>
    </section>
</main>
</body>

</html>
