<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Enums\Gender;
use App\Models\Admin;
use App\Models\GeneralUser;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            OfficesSeeder::class,
            CourseTypeSeeder::class,
            CertificateTemplateSeeder::class,
        ]);

        if (app()->environment('local')) {
            $this->call([
                CourseFieldSeeder::class,
                CourseSeeder::class,
            ]);

            \App\Models\User::factory(10)->create();

            User::create([
                'national_id' => '1234567890',
                'name' => 'trainee',
                'email' => 'trainee@gmail.com',
                'password' => Hash::make('password'),
                'is_trainee' => true,
                'gender' => Gender::MALE,
                'office_id' => 1,
                'school_id' => 1,
            ]);

            User::create([
                'national_id' => '1234567891',
                'name' => 'trainer',
                'email' => 'trainer@gmail.com',
                'password' => Hash::make('password'),
                'is_trainer' => true,
                'gender' => Gender::FEMALE,
                'office_id' => 1,
                'school_id' => 1,
            ]);

            User::create([
                'national_id' => '1234567892',
                'name' => 'user',
                'email' => 'user@gmail.com',
                'password' => Hash::make('password'),
                'is_trainer' => true,
                'is_trainee' => true,
                'gender' => Gender::MALE,
                'office_id' => 1,
                'school_id' => 1,
            ]);

        }

        Admin::create([
            'national_id' => '1234567893',
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('password'),
        ]);

        Admin::create([
            'name' => 'Super Admin',
            'national_id' => '123456',
            'email' => 'superadmin@gmail.com',
            'password' => Hash::make('password'),
            'is_super_admin' => true,
        ]);

        Admin::create([
            'name' => 'Mohamed elmilihy',
            'email' => 'moh3073@gmail.com',
            'national_id' => '1234567890',
            'password' => Hash::make('password'),
            'is_super_admin' => true,
        ]);

        GeneralUser::create([
            'name' => 'General User',
            'national_id' => '123456',
            'email' => 'general@gmail.com',
            'password' => Hash::make('password'),
        ]);

    }
}
