<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('temp_employees', function (Blueprint $table) {
            $table->id();
            $table->string('gender')->nullable();
            $table->string('education_sector')->nullable();
            $table->string('education_office')->nullable();
            $table->string('civil_registry')->nullable();
            $table->string('supervisor_name')->nullable();
            $table->string('specialization')->nullable();
            $table->string('qualification')->nullable();
            $table->string('qualification_type')->nullable();
            $table->string('university_college_institute')->nullable();
            $table->string('current_job')->nullable();
            $table->string('mobile')->nullable();
            $table->string('email')->nullable();
            $table->string('employee_status')->nullable();
            $table->string('performance_year_1444')->nullable();
            $table->string('performance_year_1443')->nullable();
            $table->string('job_title')->nullable();
            $table->string('educational_directorate_day')->nullable();
            $table->string('educational_directorate_month')->nullable();
            $table->string('educational_directorate_year')->nullable();
            $table->string('additional_qualifications')->nullable();
            $table->string('Attachment')->nullable();
            $table->string('additional_qualification_specialization')->nullable();
            $table->string('supervisory_work_assignment_date')->nullable();
            $table->string('department_office')->nullable();
            $table->string('current_department_assignment_date')->nullable();
            $table->string('rank')->nullable();
            $table->string('level')->nullable();
            $table->boolean('info_correct')->default(false);
            $table->boolean('info_correct1')->default(false);
            $table->timestamps();
        });
    }
class CreateFilesTable extends Migration
{
    public function up()
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id();
            $table->string('filename');
            $table->string('filepath');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('files');
    }
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('temp_employees');
    }
};
