<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('id_cards', function (Blueprint $table) {
            // old  $table->foreignId('user_id')->constrained('users')->cascadeOnDelete()->cascadeOnUpdate()
            // new :             $table->foreignId('general_user_id')->constrained('general_users')->cascadeOnDelete()->cascadeOnUpdate();
            $table->dropForeign(['user_id']);
            $table->renameColumn('user_id', 'general_user_id');
            $table->foreign('general_user_id')->cascadeOnDelete()->cascadeOnUpdate()->references('id')->on('general_users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('id_cards', function (Blueprint $table) {
            //
        });
    }
};
