<?php

namespace Database\Factories;

use App\Enums\Gender;
use App\Models\Course;
use App\Models\Office;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $office = Office::all()->random();
        $school = $office->schools->random();

        return [
            'national_id' => mt_rand(1000000000, 9999999999),
            'office_id' => $office->id,
            'school_id' => $school->id,
            'has_edu_job' => $this->faker->boolean(),
            'has_manager_job' => $this->faker->boolean(),
            'gender' => $this->faker->randomElement(Gender::values()),
            'phone' => $this->faker->phoneNumber(),
            'name' => fake()->name(),
            'email' => fake()->unique()->safeEmail(),
            // 'email_verified_at' => now(),
            'password' => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
            'remember_token' => Str::random(10),
            'is_trainee' => $this->faker->boolean(),
            'is_trainer' => $this->faker->boolean(),
        ];
    }

    public function configure(): static
    {
        return $this->afterMaking(function (User $user) {
            // ...
        })->afterCreating(function (User $user) {
            if ($user->is_trainee) {
                if (rand(0, 1)) {
                    $courses = Course::inRandomOrder()->limit(rand(1, 4))->AllowedCourseForTrainee($user)->get();

                    $user->traineeCourses()->attach($courses);
                }
            }

            if ($user->is_trainer) {
                if (rand(0, 1)) {
                    $courses = Course::inRandomOrder()->limit(rand(1, 10))->get();
                    $user->trainerCourses()->attach($courses);
                }
            }
        });
    }
}
