<?php

namespace Database\Factories;

use App\Models\Course;
use App\Models\CourseField;
use App\Models\CourseType;
use App\Models\Office;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Course>
 */
class CourseFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $start = $this->faker->dateTimeBetween('next Monday', 'next Monday +7 days');
        $end = $this->faker->dateTimeBetween($start, $start->format('Y-m-d H:i:s').' +2 days');

        return [
            'title' => $this->faker->name,
            'course_type_id' => CourseType::all()->random()->id,
            'course_field_id' => CourseField::all()->random()->id,
            'hours' => $this->faker->numberBetween(1, 100),
            'max_trainees' => $this->faker->numberBetween(1, 100),
            'max_trainees_per_school' => rand(4, 8),
            'start_at' => $start,

            'end_at' => $end,

            'is_online' => $this->faker->boolean(),
            'is_for_boys' => $this->faker->boolean(),
            'is_for_girls' => $this->faker->boolean(),
            'is_for_edu_job' => $this->faker->boolean(),
            'is_for_manager_job' => $this->faker->boolean(),

            'is_for_all_offices' => $this->faker->boolean(),

            'meeting_link' => $this->faker->url,
            'meeting_password' => $this->faker->password,
        ];
    }

    public function configure(): static
    {
        return $this->afterMaking(function (Course $course) {
            // ...
        })->afterCreating(function (Course $course) {
            if (! $course->is_for_all_offices) {
                $course->offices()->attach(Office::all()->random(rand(1, 4)));
            }
        });
    }
}
