<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Office extends Model
{
    use softDeletes;

    public function schools(): HasMany
    {
        return $this->hasMany(School::class)->withTrashed();
    }

    public function courses(): BelongsToMany
    {
        return $this->belongsToMany(
            Course::class,
            (new CourseOffice())->getTable(),
            'office_id',
            'course_id'
        )->withPivot('id');
    }
}
