<?php

namespace App\Models;

use Filament\Models\Contracts\FilamentUser;
use Filament\Panel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class GeneralUser extends Authenticatable implements FilamentUser
{
    use Notifiable;
    use softDeletes;

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'national_id' => 'integer',
    ];

    public function canAccessPanel(Panel $panel): bool
    {
        if ($panel->getId() == 'generalUser') {
            return true;
        }

        return false;
    }


    public function idCard(): HasOne
    {
        return $this->hasOne(IdCard::class , "general_user_id");
    }
}
