<?php

namespace App\Models;

use Filament\Models\Contracts\FilamentUser;
use Filament\Panel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable implements FilamentUser
{
    use Notifiable;
    use softDeletes;

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'national_id' => 'integer',
        'is_super_admin' => 'boolean',
        'is_has_males' => 'boolean',
        'is_has_females' => 'boolean',
        'is_has_edu_job' => 'boolean',
        'is_has_manager_job' => 'boolean',
    ];

    public function isSuperAdmin(): bool
    {
        return $this->is_super_admin;
    }

    public function isAdmin(): bool
    {
        return ! $this->is_super_admin;
    }

    public function scopeAdmin($query)
    {
        return $query->where('is_super_admin', 0);
    }

    public function scopeSuperAdmin($query)
    {
        return $query->where('is_super_admin', 1);
    }

    public function canAccessPanel(Panel $panel): bool
    {
        if ($panel->getId() == 'superAdmin' && $this->isSuperAdmin()) {
            return true;
        } elseif ($panel->getId() == 'admin' && $this->isAdmin()) {
            return true;
        } else {
            return false;
        }
    }
}
