<?php

namespace App\Livewire\Trainee;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Livewire\Component;

class ListCourseAttendances extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    public $trainee;

    public $course;

    public function mount($trainee, $course)
    {
        $this->trainee = $trainee;
        $this->course = $course;
    }

    public function table(Table $table): Table
    {
        return $table
            ->relationship(function () {
                return $this->course->attendances()->where('trainee_id', $this->trainee->id);
            })
            ->columns([
                TextColumn::make('id')
                    ->sortable()
                    ->label('ID'),

                TextColumn::make('attended_at')
                    ->dateTime()
                    ->label(__('attendance.attended_at')),

                TextColumn::make('is_attended')
                    ->label(__('attendance.is_present'))
                    ->formatStateUsing(function ($state) {
                        return $state ? 'حضور' : 'غياب';
                    }),
            ]);
    }

    public function render()
    {
        return view('livewire.trainee.list-course-attendances');
    }
}
