<?php

namespace App\Http\Controllers;

use App\Models\CertificateEvent;
use App\Models\User;
use Illuminate\Http\Request;

class UserEventCertificate extends Controller
{
    public function show(Request $request, CertificateEvent $event)
    {
        if (! $event->template_file) {
            abort(403, __('certificate.not_available'));
        }

        if (! $event->users()->where('user_id', auth()->id())->exists()) {
            abort(403, __('certificate.not_available'));
        }

        $user = auth()->user();

        $event->replaceVarsWithUser($user);

        $content = $event->content;

        return view('event_certificate', [
            'event' => $event,
            'user' => $user,
            'content' => $content,
            'temp' => asset('storage/'.$event->template_file),
            'download' => $request->query('download'),
        ]);
    }

    public function adminShow(Request $request, CertificateEvent $event, User $user)
    {
        if (! $event->template_file) {
            abort(403, __('certificate.no_template'));
        }

        $admin = auth('admin')->user();

        if (! $admin->is_super_admin) {
            abort(403, __('certificate.not_super_admin'));
        }

        if (! $event->users()->where('user_id', $user->id)->exists()) {
            abort(403, __('certificate.not_available'));
        }

        $event->replaceVarsWithUser($user);

        $content = $event->content;

        return view('event_certificate', [
            'event' => $event,
            'content' => $content,
            'user' => $user,
            'temp' => asset('storage/'.$event->template_file),
            'download' => $request->query('download'),
        ]);
    }

    public function SearchForGuest(Request $request)
    {
        $national_id = request('national_id');

        if (empty($national_id)) {
            return view('guest.search');
        }

        $national_id = arabicNumbersToEnglish($national_id);

        $user = User::whereNationalId($national_id)->first();

        if (! $user) {
            return back()->with('error', __('error.user_not_found'));
        }

        return redirect(route('guest.event.certificate.index', ['user' => $user]));
    }

    public function guestCerts(Request $request, User $user)
    {
        $certs = $user->eventCertificate;

        return view('guest.event_certificates', [
            'user' => $user,
            'certs' => $certs,
        ]);
    }

    public function guestCert(Request $request, User $user, CertificateEvent $event)
    {
        if (! $event->template_file) {
            abort(403, __('certificate.no_template'));
        }

        if (! $event->users()->where('user_id', $user->id)->exists()) {
            abort(403, __('certificate.not_available'));
        }

        $event->replaceVarsWithUser($user);

        $content = $event->content;

        return view('event_certificate', [
            'event' => $event,
            'content' => $content,
            'user' => $user,
            'temp' => asset('storage/'.$event->template_file),
            'download' => $request->query('download'),
        ]);
    }
}
