<?php

namespace App\Http\Controllers;

use App\Models\CertificateTemplate;
use App\Models\Course;
use App\Models\User;
use Illuminate\Http\Request;

class TraineeCertificateController extends Controller
{
    public function show(Request $request, Course $course)
    {
        $template = CertificateTemplate::traineeTemplate();

        if (! $template || ! $template->template_file) {
            abort(403, __('certificate.not_available'));
        }

        $trainee = auth()->user();

        if (! $trainee->is_trainee) {
            abort(403, __('certificate.not_trainee'));
        }

        if (! $course->isEnded()) {
            abort(403, __('certificate.not_ended'));
        }

        if (! $course->trainees()->where('trainee_id', $trainee->id)->exists()) {
            abort(403, __('certificate.not_trainee_of_course'));
        }

        if (! auth()->user()->canGetHisCertifcateForCourse($course)) {
            abort(403, __('admin.cannot_get_certificate_attendances_limit_not_reached'));
        }

        return view('certificate', [
            'course' => $course,
            'user' => $trainee,
            'temp' => asset('storage/'.$template->template_file),
            'download' => $request->query('download'),
        ]);
    }

    public function adminShow(Request $request, Course $course, User $user)
    {
        $template = CertificateTemplate::traineeTemplate();

        if (! $template || ! $template->template_file) {
            abort(403, __('certificate.no_template'));
        }

        $admin = auth('admin')->user();

        if (! $admin->is_super_admin) {
            abort(403, __('certificate.not_super_admin'));
        }

        if (! $user->is_trainee) {
            abort(403, __('certificate.user_not_trainee'));
        }

        if (! $course->trainees()->where('trainee_id', $user->id)->exists()) {
            abort(403, __('certificate.user_not_trainee_of_course'));
        }

        return view('certificate', [
            'course' => $course,
            'user' => $user,
            'temp' => asset('storage/'.$template->template_file),
            'download' => $request->query('download'),
        ]);
    }
}
