<?php

namespace App\Http\Controllers\Temp;

use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateTempEmployeeRequest;
use App\Imports\TempEmpImport;
use App\Models\TempEmployee;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;

class EmployeeController extends Controller
{

    public function import()
    {
        TempEmployee::truncate();
        $excel_file = Storage::disk('local')->path('public/TempEmployee.xlsx');
        Excel::import(new TempEmpImport, $excel_file);

        return "done";
    }

    public function loginForm(Request $request)
    {
        if ($request->has('civil_registry')) {
            $employee = TempEmployee::where('civil_registry', $request->civil_registry)->first();

            if ($employee) {
                return redirect(route('temp.employee.show', $employee));
            }

            return redirect(route('temp.employee.login'))->with('error', 'الرقم المدني غير موجود');
        }

        return view('tempEmp.login');
    }

    public function show(TempEmployee $employee)
    {
        // magister / doctora
        $additional_qualifications = [
            "لا يوجد",
            "ماجستير",
            "دكتوراه",
        ];

        $qualification_types = [
            "تربوي",
            "غير تربوي",
        ];

        return view('tempEmp.show', [
            'emp' => $employee,
            'additional_qualifications' => $additional_qualifications,
            'qualification_types' => $qualification_types,
        ]);
    }

    public function update(UpdateTempEmployeeRequest $request, TempEmployee $employee)
    {
        // Validate the form data, including the file
        $request->validate([
            'email' => 'required|email',
            'mobile' => 'required',
            'Attachment' => 'file|mimes:pdf,doc,docx|max:2048', // Adjust allowed file types and size
            // Add more validation rules as needed
			
        ]);

        // Handle file upload
        if ($request->hasFile('Attachment')) {
            $file = $request->file('Attachment');
            $fileName = time() . '_' . $file->getClientOriginalName();
            $file->storeAs('Attachments', $fileName, 'public'); // Change the storage path if needed

            // Update the employee record with the file information
            $employee->update([
                'Attachment' => $fileName,
            ]);
        }

        // Update other data in the database
        $data = $request->validated();

        if ($data['info_correct'] == 'ok') {
            $data['info_correct'] = true;
        }
		
        if ($data['info_correct1'] == 'ok') {
            $data['info_correct1'] = true;
        }

        $employee->update($data);

        // Redirect back with a success message
        return redirect(route('temp.employee.show', $employee))->with('success', 'تم تحديث البيانات بنجاح.');

        
    }

  

}
