<?php

function englishNumberToArabic($value, $reverse = false): string
{
    if ($reverse) {
        $value = strrev($value);
    }
    $hindi_numbers = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    $arabic_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];

    return str_replace($arabic_numbers, $hindi_numbers, $value);
}

function arabicNumbersToEnglish($number)
{
    $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    $english = range(0, 9);

    // 1234567890
    // ١٢٣٤٥٦٧٨٩٠
    return str_replace($arabic, $english, $number);
}
