<?php

namespace App\Filament\SuperAdmin\Resources\TrainerResource\RelationManagers;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class TrainerCoursesRelationManager extends RelationManager
{
    protected static string $relationship = 'trainerCourses';

    protected static ?string $inverseRelationship = 'trainers';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('admin.relation.trainer_courses');
    }

    public static function getPluralRecordLabel(): ?string
    {
        return __('admin.relation.trainer_courses');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getRecordLabel(): ?string
    {
        return __('admin.relation.trainer_course');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make()
                    ->columns([
                        '2xl' => 2,
                    ])
                    ->schema([
                        Select::make('course_type_id')
                            ->relationship('type', 'name')
                            ->required()
                            ->label(__('input.type')),

                        TextInput::make('title')
                            ->label(__('input.title'))
                            ->required()
                            ->maxLength(255),
                    ]),
                Section::make()
                    ->columns([
                        '2xl' => 2,
                    ])
                    ->schema([
                        DateTimePicker::make('start_at')
                            ->label(__('input.start_at'))
                            ->columns(6)
                            ->required(),
                        DateTimePicker::make('end_at')
                            ->label(__('input.end_at'))
                            ->columns(6)
                            ->required(),
                    ]),

                Section::make()
                    ->columns([
                        '2xl' => 3,
                    ])
                    ->schema([
                        TextInput::make('hours')
                            ->numeric()
                            ->label(__('input.hours'))
                            ->required(),
                        TextInput::make('max_trainees')
                            ->numeric()
                            ->label(__('input.max_trainees'))
                            ->required(),
                        TextInput::make('max_trainees_per_school')
                            ->numeric()
                            ->label(__('input.max_trainees_per_school'))
                            ->required(),
                    ]),

                Section::make()
                    ->columns([
                        '2xl' => 3,
                    ])
                    ->schema([
                        Toggle::make('is_online')
                            ->label(__('input.is_online')),
                        TextInput::make('meeting_link')
                            ->visible(function ($get) {
                                return $get('is_online');
                            })->required(function ($get) {
                                return $get('is_online');
                            })
                            ->label(__('input.meeting_link'))
                            ->hint(__('input.meeting_link_hint'))
                            ->maxLength(255),
                        TextInput::make('meeting_password')
                            ->visible(function ($get) {
                                return $get('is_online');
                            })
                            ->label(__('input.meeting_password'))
                            ->hint(__('input.meeting_password_hint'))
                            ->maxLength(255),
                    ]),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->columns([
                Tables\Columns\TextColumn::make('type.name')
                    ->sortable()
                    ->searchable()
                    ->toggleable()
                    ->label(__('input.type')),

                Tables\Columns\TextColumn::make('title')
                    ->sortable()
                    ->searchable()
                    ->label(__('input.title')),

                Tables\Columns\TextColumn::make('start_at')
                    ->date()
                    ->sortable()
                    ->toggleable()
                    ->searchable()
                    ->label(__('input.start_at')),
                Tables\Columns\TextColumn::make('end_at')
                    ->date()
                    ->sortable()
                    ->toggleable()
                    ->searchable()
                    ->label(__('input.end_at')),

                Tables\Columns\TextColumn::make('hours')
                    ->sortable()
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->label(__('input.hours')),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->headerActions([
                Tables\Actions\AttachAction::make(),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\DetachAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DetachBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\AttachAction::make(),
            ])
            ->modifyQueryUsing(fn (Builder $query) => $query->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]));
    }
}
