<?php

namespace App\Filament\SuperAdmin\Resources\TraineeResource\Pages;

use App\Filament\SuperAdmin\Resources\TraineeResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Hash;

class EditTrainee extends EditRecord
{
    protected static string $resource = TraineeResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    public function mutateFormDataBeforeSave($data): array
    {
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
            unset($data['password_confirmation']);
        } else {
            unset($data['password']);
            unset($data['password_confirmation']);
        }

        return $data;
    }
}
