<?php

namespace App\Filament\SuperAdmin\Resources\SchoolResource\Pages;

use App\Filament\SuperAdmin\Resources\SchoolResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ListSchools extends ListRecords
{
    protected static string $resource = SchoolResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
            ImportAction::make()
                ->uniqueField('id')
                ->fields([
                    ImportField::make('office_id')
                        ->required()
                        ->rules('exists:offices,id')
                        ->label(__('input.office')),

                    ImportField::make('name')
                        ->required()
                        ->label(__('input.name')),

                    ImportField::make('id')
                        ->required()
                        ->label(__('input.ministerial_number')),
                ])
                ->handleBlankRows(true)
                ->mutateBeforeCreate(function ($row) {
                    return array_map('trim', $row);
                }),
        ];
    }
}
