<?php

namespace App\Filament\SuperAdmin\Resources\OfficeResource\Pages;

use App\Filament\SuperAdmin\Resources\OfficeResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ListOffices extends ListRecords
{
    protected static string $resource = OfficeResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
            ImportAction::make()
                ->uniqueField('name')
                ->fields([
                    ImportField::make('name')
                        ->required()
                        ->label(__('input.name')),
                ])
                ->handleBlankRows(true)
                ->mutateBeforeCreate(function ($row) {
                    return array_map('trim', $row);
                }),
        ];
    }
}
