<?php

namespace App\Filament\SuperAdmin\Resources\GeneralUserResource\Pages;

use App\Filament\SuperAdmin\Resources\GeneralUserResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\Hash;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ListGeneralUsers extends ListRecords
{
    protected static string $resource = GeneralUserResource::class;

    public function getTabs(): array
    {
        return [
            null => ListRecords\Tab::make(__('filters.menu.all')),
            'has_confirmed_at' => ListRecords\Tab::make(__('filters.menu.confirmed'))->query(fn ($query) => $query->whereHas('idCard', fn ($query) => $query->whereNotNull('confirmed_at'))),
            'has_not_confirmed_at' => ListRecords\Tab::make(__('filters.menu.not_confirmed'))->query(fn ($query) => $query->whereHas('idCard', fn ($query) => $query->whereNull('confirmed_at'))),
            "dosnt_have_id_card" => ListRecords\Tab::make(__('filters.menu.dosnt_have_id_card'))->query(fn ($query) => $query->doesntHave('idCard')),
        ];
    }


    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
            ImportAction::make()
                ->uniqueField('national_id')
                ->fields([
                    ImportField::make('name')
                        ->required()
                        ->label(__('input.name')),

                    ImportField::make('email')
                        ->rules(['email'])
                        ->required()
                        ->label(__('input.email')),

                    ImportField::make('national_id')
                        ->rules(['numeric'])
                        ->required()
                        ->label(__('input.national_id')),
                ])
                ->handleBlankRows(true)
                ->mutateBeforeCreate(function ($row) {
                    $row = array_map('trim', $row);
                    $national_id = $row['national_id'];
                    $row['password'] = Hash::make($national_id);
                    return $row;
                }),
        ];
    }
}
