<?php

namespace App\Filament\SuperAdmin\Resources\CourseResource\Pages;

use App\Filament\SuperAdmin\Resources\CourseResource;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ViewCourse extends ViewRecord
{
    protected static string $resource = CourseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            $this->addTrainersImportAction(),
            $this->addTraineesImportAction(),
            $this->addTraineesAttendanceImportAction(),
        ];
    }

    private function addTrainersImportAction()
    {
        return ImportAction::make('upload_trainers_list')
            ->label(__('action.upload_trainers_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                if (!empty($data['national_id'])) {
                    $user = User::withTrashed()->trainer()->whereNationalId($data['national_id'])->first();

                    if ($user) {
                        $this->record->trainers()->syncWithoutDetaching([$user->id]);
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }

    private function addTraineesImportAction()
    {
        return ImportAction::make('upload_trainees_list')
            ->label(__('action.upload_trainees_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                if (!empty($data['national_id'])) {
                    $user = User::withTrashed()->trainee()->whereNationalId($data['national_id'])->first();

                    if ($user) {
                        $this->record->trainees()->syncWithoutDetaching([$user->id]);
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }

    private function addTraineesAttendanceImportAction()
    {
        return ImportAction::make('upload_trainees_attendance_list')
            ->label(__('action.upload_trainees_attendance_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                if (!empty($data['national_id'])) {
                    $user = $this->record->trainees()->whereNationalId($data['national_id'])->first();

                    if ($user) {
                        $days = $this->record->getDays();

                        foreach ($days as $day) {
                            $this->record->attendances()->firstOrCreate([
                                'course_trainee_id' => $user->pivot->id,
                                'attended_at' => $day,
                            ]);
                        }
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }
}
