<?php

namespace App\Filament\SuperAdmin\Resources\CertificateEventResource\Pages;

use App\Filament\SuperAdmin\Resources\CertificateEventResource;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class EditCertificateEvent extends EditRecord
{
    protected static string $resource = CertificateEventResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),

            $this->addUsersImportAction(),
        ];
    }

    private function addUsersImportAction()
    {
        return ImportAction::make('upload_users_list')
            ->label(__('action.upload_users_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->label(__('input.national_id')),

            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = User::withTrashed()->where('national_id', $data['national_id'])->first();

                if ($user) {
                    $this->record->users()->syncWithoutDetaching($user->id);
                }

                return $data;
            })->disableRecordCreation();
    }
}
