<?php

namespace App\Filament\SuperAdmin\Resources;

use App\Filament\SuperAdmin\Resources\CertificateEventResource\Pages;
use App\Filament\SuperAdmin\Resources\CertificateEventResource\RelationManagers\UsersRelationManager;
use App\Models\CertificateEvent;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CertificateEventResource extends Resource
{
    protected static ?string $model = CertificateEvent::class;

    protected static ?string $navigationIcon = 'heroicon-o-document';

    public static function getNavigationBadge(): ?string
    {
        return static::$model::count();
    }

    public static function getNavigationLabel(): string
    {
        return __('admin.certificate_events');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('admin.group.courses');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getPluralLabel(): ?string
    {
        return __('admin.certificate_events');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getLabel(): ?string
    {
        return __('admin.certificate_event');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('title')
                    ->required()
                    ->autofocus()
                    ->columnSpanFull()
                    ->label(__('input.name'))
                    ->placeholder(__('input.name_placeholder')),

                Textarea::make('content')
                    ->required()
                    ->autofocus()
                    ->columnSpanFull()
                    ->label(__('input.content'))
                    ->helperText('__user_name__ , __national_id__'),

                FileUpload::make('template_file')
                    ->columnSpanFull()
                    ->required()
                    ->openable()
                    ->downloadable()
                    ->acceptedFileTypes(['application/pdf'])
                    ->label(__('input.template_file'))
                    ->placeholder(__('input.template_file')),

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('input.name'))
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            UsersRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCertificateEvents::route('/'),
            'create' => Pages\CreateCertificateEvent::route('/create'),
            'edit' => Pages\EditCertificateEvent::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
