<?php

namespace App\Filament\SuperAdmin\Resources\AdminResource\Pages;

use App\Filament\SuperAdmin\Resources\AdminResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\Hash;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ListAdmins extends ListRecords
{
    protected static string $resource = AdminResource::class;

    public function getTabs(): array
    {
        return [
            null => ListRecords\Tab::make(__('filters.menu.all')),
            'admins' => ListRecords\Tab::make(__('filters.menu.admins'))->query(fn ($query) => $query->Admin()),
            'super_admins' => ListRecords\Tab::make(__('filters.menu.super_admins'))->query(fn ($query) => $query->SuperAdmin()),
        ];
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
            ImportAction::make()
                ->uniqueField('national_id')
                ->fields([
                    ImportField::make('name')
                        ->required()
                        ->label(__('input.name')),

                    ImportField::make('email')
                        ->rules(['email'])
                        ->required()
                        ->label(__('input.email')),

                    ImportField::make('national_id')
                        ->rules(['numeric'])
                        ->required()
                        ->label(__('input.national_id')),

                    ImportField::make('is_super_admin')
                        ->required()
                        ->rules(['boolean'])
                        ->label(__('input.is_super_admin')),

                    ImportField::make('is_has_males')
                        ->rules(['boolean'])
                        ->label(__('input.is_has_males')),

                    ImportField::make('is_has_females')
                        ->rules(['boolean'])
                        ->label(__('input.is_has_females')),

                    ImportField::make('is_has_edu_job')
                        ->rules(['boolean'])
                        ->label(__('input.is_has_edu_job')),

                    ImportField::make('is_has_manager_job')
                        ->rules(['boolean'])
                        ->label(__('input.is_has_manager_job')),
                ])
                ->handleBlankRows(true)
                ->mutateBeforeCreate(function ($row) {
                    $row = array_map('trim', $row);
                    $national_id = $row['national_id'];
                    $row['password'] = Hash::make($national_id);

                    if (! isset($row['is_has_males'])) {
                        $row['is_has_males'] = false;
                    }
                    if (! isset($row['is_has_females'])) {
                        $row['is_has_females'] = false;
                    }
                    if (! isset($row['is_has_edu_job'])) {
                        $row['is_has_edu_job'] = false;
                    }
                    if (! isset($row['is_has_manager_job'])) {
                        $row['is_has_manager_job'] = false;
                    }

                    if ($row['is_super_admin']) {
                        $row['is_has_males'] = true;
                        $row['is_has_females'] = true;
                        $row['is_has_edu_job'] = true;
                        $row['is_has_manager_job'] = true;
                    }

                    return $row;
                }),
        ];
    }
}
