<?php

namespace App\Filament\GeneralUser\Resources;

use App\Models\CertificateEvent;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class CertificateEventResource extends Resource
{
    protected static ?string $model = CertificateEvent::class;

    protected static ?string $navigationIcon = 'heroicon-o-document';

    public static function getNavigationBadge(): ?string
    {
        return static::$model::OfCurrentUser()->count();
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()->OfCurrentUser();
    }

    public static function getNavigationLabel(): string
    {
        return __('admin.thanks_certificates');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getPluralLabel(): ?string
    {
        return __('admin.thanks_certificates');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getLabel(): ?string
    {
        return __('admin.thanks_certificates');
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->label(__('input.name'))
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\Action::make('view')
                    ->label(__('admin.view_certificate'))
                    ->button()
                    ->url(function ($record) {
                        return route('user.event.certificate', ['event' => $record]);
                    }, shouldOpenInNewTab: true),

                Tables\Actions\Action::make('download')
                    ->label(__('admin.download_certificate'))
                    ->button()
                    ->url(function ($record) {
                        return route('user.event.certificate', ['event' => $record, 'download' => true]);
                    }, shouldOpenInNewTab: true),
            ])
            ->bulkActions([
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => \App\Filament\GeneralUser\Resources\CertificateEventResource\Pages\ListCertificateEvents::route('/'),
        ];
    }
}
