<?php

namespace App\Filament\Employee\Widgets\Trainee;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class MaxCoursesPerYear extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    public static function canView(): bool
    {
        return auth()->user()->is_trainee;
    }

    protected function getStats(): array
    {
        $traineeUsedCourses = auth()->user()->traineeCourses()->whereYear('course_trainees.created_at', now()->year)->count();

        $traineeAvailableCourses = auth()->user()->max_courses_per_year;

        $remainingCourses = $traineeAvailableCourses - $traineeUsedCourses;

        $color = $remainingCourses > 0 ? 'success' : 'danger';

        return [
            Stat::make(
                label : __('admin.trainee_remaining_courses'),
                value : $remainingCourses,
            )->description(
                __('admin.max_courses_per_year', ['max_courses_per_year' => $traineeAvailableCourses])
            )->color($color),
        ];
    }
}
