<?php

namespace App\Filament\Employee\Resources\Trainer\MyCourseResource\RelationManagers;

use App\Exports\CourseTraineesExport;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use pxlrbt\FilamentExcel\Actions\Tables\ExportAction;

class TraineesRelationManager extends RelationManager
{
    protected static string $relationship = 'trainees';

    protected static ?string $inverseRelationship = 'traineeCourses';

    protected static ?string $recordTitleAttribute = 'name';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('admin.relation.trainees');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getPluralRecordLabel(): ?string
    {
        return __('admin.relation.trainees');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getRecordLabel(): ?string
    {
        return __('admin.relation.trainee');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('national_id')
                    ->required()
                    ->numeric()
                    ->autofocus()
                    ->unique(ignoreRecord: true)
                    ->label(__('trainer.national_id'))
                    ->placeholder(__('trainer.national_id_placeholder'))
                    ->helperText(__('trainer.national_id_helper_text')),

                TextInput::make('name')
                    ->required()
                    ->autofocus()
                    ->label(__('trainer.name'))
                    ->placeholder(__('trainer.name_placeholder'))
                    ->helperText(__('trainer.name_helper_text')),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                TextColumn::make('id')
                    ->sortable()
                    ->searchable()
                    ->label('ID'),
                TextColumn::make('national_id')
                    ->sortable()
                    ->searchable()
                    ->label(__('trainer.national_id')),

                TextColumn::make('name')
                    ->sortable()
                    ->searchable()
                    ->label(__('trainer.name')),

                Tables\Columns\TextColumn::make('office.name')
                    ->sortable()
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->label(__('trainer.office')),

                Tables\Columns\TextColumn::make('school.name')
                    ->sortable()
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->label(__('trainer.school')),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                ExportAction::make()->exports([
                    CourseTraineesExport::make()
                        ->askForFilename(
                            default: $this->ownerRecord->title.' - trainees - '.date('Y-m-d').' - export',
                            label : __('action.export_file_name')
                        ),
                ]),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                ]),
            ]);
    }
}
