<?php

namespace App\Filament\Employee\Resources\Trainer\MyCourseResource\Pages;

use App\Filament\Employee\Resources\Trainer\MyCourseResource;
use Filament\Resources\Pages\ViewRecord;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ViewMyCourse extends ViewRecord
{
    protected static string $resource = MyCourseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            $this->addTraineesAttendanceImportAction(),
        ];
    }

    private function addTraineesAttendanceImportAction()
    {
        return ImportAction::make('upload_trainees_attendance_list')
            ->label(__('action.upload_trainees_attendance_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->rules('exists:users,national_id')
                    ->label(__('input.national_id')),

            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = $this->record->trainees()->whereNationalId($data['national_id'])->first();

                if ($user) {
                    $days = $this->record->getDays();

                    foreach ($days as $day) {
                        $this->record->attendances()->firstOrCreate([
                            'course_trainee_id' => $user->pivot->id,
                            'attended_at' => $day,
                        ]);
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }
}
