<?php

namespace App\Filament\Employee\Resources\Trainee;

use App\Filament\Employee\Resources\Trainee\MyCertificateResource\Pages;
use App\Infolists\Components\ViewCertificateEntry;
use App\Models\Course;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Infolist;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\HtmlString;

class MyCertificateResource extends Resource
{
    protected static ?string $model = Course::class;

    protected static ?string $navigationIcon = 'heroicon-o-academic-cap';

    protected static ?string $recordTitleAttribute = 'title';

    public static function canViewAny(): bool
    {
        return auth()->user()->is_trainee;
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()->OfCurrentTrainee()->Ended();
    }

    public static function getNavigationBadge(): ?string
    {
        return static::$model::OfCurrentTrainee()->Ended()->count();
    }

    public static function getNavigationLabel(): string
    {
        return __('admin.certificates');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('admin.group.trainee');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getPluralLabel(): ?string
    {
        return __('admin.certificates');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getLabel(): ?string
    {
        return __('admin.certificate');
    }

    //    public static function infolist(Infolist $infolist): Infolist
    //    {
    //        return $infolist->schema([
    //            Section::make()
    //                ->columns(2)
    //                ->icon('heroicon-o-clock')
    //                ->heading(function ($record) {
    //                    return new HtmlString(
    //                        $record->title.' - ('.$record->start_at->format('d/m/Y').' - '.$record->end_at->format('d/m/Y').') '.
    //                        '<a href="'
    //                        .route('trainee.certificate', ['course' => $record, 'download' => true]).
    //                        '" class="float-right text-green-600 hover:text-green-900" target="_blank">'.
    //                        __('admin.download_certificate').
    //                        '</i></a>'
    //                    );
    //                })
    //                ->schema([
    //                    ViewCertificateEntry::make('certificate')
    //                        ->label('')
    //                        ->columnSpanFull(),
    //                ]),
    //        ])
    //            ->columns(2);
    //    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('title')
                    ->sortable()
                    ->searchable()
                    ->extraAttributes(['class' => 'mb-4'])
                    ->icon('heroicon-o-academic-cap')
                    ->label(__('input.title')),

                Tables\Columns\TextColumn::make('start_at')
                    ->date()
                    ->sortable()
                    ->searchable()
                    ->tooltip(function ($state) {
                        return $state->diffForHumans();
                    })
                    ->label(__('input.start_at'))
                    ->icon('heroicon-o-arrow-left')
                    ->formatStateUsing(function ($state) {
                        return $state->format('d-m-Y h:iA');
                    }),
                Tables\Columns\TextColumn::make('end_at')
                    ->date()
                    ->sortable()
                    ->searchable()
                    ->label(__('input.end_at'))
                    ->tooltip(function ($state) {
                        return $state->diffForHumans();
                    })
                    ->icon('heroicon-o-arrow-left')
                    ->formatStateUsing(function ($state) {
                        return $state->format('d-m-Y h:iA');
                    }),
            ])
            ->filters([
                //
            ])
            ->actions([
                //                Tables\Actions\ViewAction::make(),
                Tables\Actions\Action::make('view')
                    ->label(__('admin.view_certificate'))
                    ->icon('heroicon-o-eye')
                    ->button()
                    ->disabled(function ($record) {
                        return ! auth()->user()->canGetHisCertifcateForCourse($record);
                    })
                    ->url(function ($record) {
                        return route('trainee.certificate', ['course' => $record]);
                    }, shouldOpenInNewTab: true),
                Tables\Actions\Action::make('download')
                    ->label(__('admin.download_certificate'))
                    ->icon('heroicon-o-arrow-down-tray')
                    ->button()
                    ->disabled(function ($record) {
                        return ! auth()->user()->canGetHisCertifcateForCourse($record);
                    })
                    ->url(function ($record) {
                        return route('trainee.certificate', ['course' => $record, 'download' => true]);
                    }, shouldOpenInNewTab: true),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMyCertificates::route('/'),
        ];
    }
}
