<?php

namespace App\Filament\Employee\Resources\Trainee\CourseResource\Widgets;

use App\Models\Course;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    public ?Course $record = null;

    protected static ?string $pollingInterval = '10s';

    protected static ?int $sort = -4;

    protected function getStats(): array
    {
        $remaining_trainees_count = $this->record->remaining_trainees_count;

        return [
            Stat::make(
                label: __('input.max_trainees_per_school'),
                value: $this->record->max_trainees_per_school,
            ),

            Stat::make(
                label: __('input.max_trainees'),
                value: $this->record->max_trainees,
            ),

            Stat::make(
                label: __('input.remaining_trainees_count'),
                value: $remaining_trainees_count,
            )->color(
                $remaining_trainees_count > 0 ? 'success' : 'danger',
            ),

            Stat::make(
                label: __('input.hours'),
                value: $this->record->hours,
            ),
        ];
    }
}
