<?php

namespace App\Filament\Admin\Resources\UserResource\Pages;

use App\Filament\Admin\Resources\UserResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
            unset($data['password_confirmation']);
        } else {
            unset($data['password']);
            unset($data['password_confirmation']);
        }

        return $data;
    }
}
