<?php

namespace App\Filament\Admin\Pages;

use Filament\Forms\Components\Component;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Auth\EditProfile as FilamentEditProfile;

class EditProfile extends FilamentEditProfile
{
    protected function getUpdateNationaIdFormComponent(): Component
    {
        return TextInput::make('national_id')
            ->required()
            ->numeric()
            ->autofocus()
            ->unique(ignoreRecord: true)
            ->disabled()
            ->label(__('input.national_id'))
            ->placeholder(__('input.national_id_placeholder'))
            ->helperText(__('input.national_id_helper_text'));
    }

    protected function getNameFormComponent(): Component
    {
        return TextInput::make('name')
            ->label(__('filament-panels::pages/auth/edit-profile.form.name.label'))
            ->required()
            ->maxLength(255)
            ->autofocus();
    }

    /**
     * @return array<int | string, string | Form>
     */
    protected function getForms(): array
    {
        return [
            'form' => $this->form(
                $this->makeForm()
                    ->schema([
                        $this->getUpdateNationaIdFormComponent(),
                        $this->getNameFormComponent(),
                        $this->getEmailFormComponent(),
                        $this->getPasswordFormComponent(),
                        $this->getPasswordConfirmationFormComponent(),
                    ])
                    ->operation('edit')
                    ->model($this->getUser())
                    ->statePath('data'),
            ),
        ];
    }
}
